/**
 * Created by lei.wang_1 on 2016/8/2.
 */
appModule.directive("noticeCheckbox", [function () {
    return {
        template: '<div class="checkbox" ng-click="onChecked($event)">'
                    +'<span class="icon" ng-class="{\'disabled\':disabled}"></span>'
                    +'<span ng-bind="targetText" class="targetText" ng-class="{\'disabled\':disabled}"></span></div>',
        restrict: 'E',
        replace:true,
        scope: {
            target:'=',
            targetText:'@',
            disabled:"=",
            intType:"@"
        },
        link: function ($scope, element) {
            var stopWatchTarget = $scope.$watch('target',function(newV){
               if(newV && !$scope.disabled){
                   element.find('.icon').addClass('selected');
               }else{
                   element.find('.icon').removeClass('selected');
               }
            });

            $scope.onChecked = function(e){
                e.stopPropagation();
                if(!$scope.disabled){
                    if($scope.intType){
                        $scope.target = $scope.target? 0 : 1;
                    }else{
                        $scope.target = !$scope.target;
                    }
                }
            };

            $scope.$on('$destroy',function(){
                stopWatchTarget();
            });
        }
    };
}]);
